/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DoubleNumericSpinner;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.DateParameterJPanel;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.dialog.comp.Measurement;
import DE.siemens.ad.logo.dialog.comp.MeasurementPanel;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.dialog.comp.TimeOrReferenceSycnPanel;
import DE.siemens.ad.logo.dialog.comp.TimeValueOrReferencePanel;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogFilterParameter;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.AverageValueParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.ComfortSwitchParameter;
import DE.siemens.ad.logo.model.FrequencyParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.MaxMinParameter;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.StairsSwitchParameter;
import DE.siemens.ad.logo.model.StopWatchParameter;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.TimeParameterInterface;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.WipingRelayPECParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.model.panel.AnalogFilterPanel;
import DE.siemens.ad.logo.model.panel.AverageValuePanel;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.model.panel.StopWatchPanel;
import DE.siemens.ad.logo.model.panel.TheodolitePanel;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.CodeBlock;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class UDFBlockPanel
extends BlockParameterPanel {
    private static final long serialVersionUID = -5381678082795006497L;
    private JPanel contentPanel;
    private Map<Object, Component> subParamJPanels = null;

    public UDFBlockPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.init();
    }

    protected void init() {
        UDFBlockParameter udfParameter = (UDFBlockParameter)this.getParameterReference();
        ParameterItemList itemList = udfParameter.getParameterItems();
        if (itemList.size() == 0) {
            return;
        }
        JPanel paramPanel = new JPanel();
        this.addParameterPane(paramPanel);
        paramPanel.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JScrollPane jsp = new JScrollPane(centerPanel);
        paramPanel.add((Component)jsp, "Center");
        centerPanel.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        centerPanel.add((Component)this.contentPanel, "North");
        this.initSubParamJPanels();
    }

    private void initSubParamJPanels() {
        GridBagConstraints constraints;
        ArrayList<UDFParameterItem> items;
        List<UDFParameterItem> items2;
        GridBagLayout layout = new GridBagLayout();
        this.contentPanel.setLayout(layout);
        this.subParamJPanels = new HashMap<Object, Component>();
        BorderJPanel subParamJPanel = null;
        ParameterItemList itemList = ((BlockParameter)this.getParameterReference()).getParameterItems();
        int i = 0;
        HashMap specialItems = new HashMap();
        for (Object udfParamItem : itemList) {
            ParameterItem srcParamItem = ((UDFParameterItem)udfParamItem).getRootSourceParameterItem();
            if (srcParamItem.getParameterValueType() != 0) continue;
            if (srcParamItem.getParameter() instanceof ClockParameter) {
                CamParameter camParameter = UDFBlockPanel.getCamParameter(srcParamItem);
                if (camParameter == null) continue;
                items2 = null;
                if (specialItems.containsKey(camParameter)) {
                    items2 = (List)specialItems.get(camParameter);
                } else {
                    items2 = new ArrayList();
                    specialItems.put(camParameter, items2);
                }
                items2.add((UDFParameterItem)udfParamItem);
                continue;
            }
            if (srcParamItem.getParameter() instanceof AstronomicalClockParameter || srcParamItem.getParameter() instanceof AverageValueParameter || srcParamItem.getParameter() instanceof Analog && (srcParamItem.getIdentifier().equals("A") || srcParamItem.getIdentifier().equals("B")) || (srcParamItem.getParameter() instanceof StairsSwitchParameter || srcParamItem.getParameter() instanceof ComfortSwitchParameter) && (srcParamItem.getIdentifier().equals("T") || srcParamItem.getIdentifier().equals("TH") || srcParamItem.getIdentifier().equals("T!") || srcParamItem.getIdentifier().equals("T!L"))) {
                items = null;
                if (specialItems.containsKey(srcParamItem.getParameter())) {
                    items = (List)specialItems.get(srcParamItem.getParameter());
                } else {
                    items = new ArrayList();
                    specialItems.put(srcParamItem.getParameter(), items);
                }
                items.add((UDFParameterItem)udfParamItem);
                continue;
            }
            Object paramValue = srcParamItem.getValue();
            if (paramValue instanceof ValueOrItemReference && ((ValueOrItemReference)paramValue).isReference()) {
                UDFBlock udf = (UDFBlock)((UDFBlockParameter)this.getParameterReference()).getBlock();
                Block referBlk = ((ValueOrItemReference)paramValue).getReference().getParameter().getBlock();
                if (udf.getBlocks().contains(referBlk)) continue;
            }
            CodeBlock codeBlock = new CodeBlock(this, "createParameterJPanel");
            try {
                codeBlock.addParameter(paramValue);
                codeBlock.addParameter(srcParamItem);
                subParamJPanel = (BorderJPanel)codeBlock.execMethod();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("=============" + ((UDFParameterItem)udfParamItem).getIdentifier());
                throw new NoSuchMethodError();
            }
            subParamJPanel.setTitle(((UDFParameterItem)udfParamItem).getIdentifier());
            subParamJPanel.setTitleColor(Color.BLUE);
            subParamJPanel.setLayout(new FlowLayout(0));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i++;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.anchor = 17;
            this.contentPanel.add((Component)subParamJPanel, constraints);
            this.subParamJPanels.put(udfParamItem, subParamJPanel);
        }
        Set specialItem = specialItems.keySet();
        for (BlockParameter parameter : specialItem) {
            GridBagConstraints constraints2;
            if (parameter instanceof CamParameter) {
                CamParameter cp = (CamParameter)parameter;
                items2 = (ArrayList)specialItems.get(cp);
                UDFParameterItem weekdayItem = null;
                UDFParameterItem onTimeItem = null;
                UDFParameterItem offItem = null;
                for (UDFParameterItem parameterItem : items2) {
                    ParameterItem srcParamItem = parameterItem.getRootSourceParameterItem();
                    if ("On0".equals(srcParamItem.getIdentifier()) || "On1".equals(srcParamItem.getIdentifier()) || "On2".equals(srcParamItem.getIdentifier())) {
                        onTimeItem = parameterItem;
                        continue;
                    }
                    if ("Off0".equals(srcParamItem.getIdentifier()) || "Off1".equals(srcParamItem.getIdentifier()) || "Off2".equals(srcParamItem.getIdentifier())) {
                        offItem = parameterItem;
                        continue;
                    }
                    if (!"D0".equals(srcParamItem.getIdentifier()) && !"D1".equals(srcParamItem.getIdentifier()) && !"D2".equals(srcParamItem.getIdentifier())) continue;
                    weekdayItem = parameterItem;
                }
                CamParameterPanel camPanel = new CamParameterPanel(cp, weekdayItem, onTimeItem, offItem);
                GridBagConstraints constraints3 = new GridBagConstraints();
                constraints3.gridx = 0;
                constraints3.gridy = i++;
                constraints3.fill = 2;
                constraints3.insets = new Insets(0, 0, 0, 0);
                constraints3.anchor = 17;
                this.contentPanel.add((Component)camPanel, constraints3);
                this.subParamJPanels.put(cp, camPanel);
                continue;
            }
            if (parameter instanceof AstronomicalClockParameter) {
                AstronomicalClockParameter acP = (AstronomicalClockParameter)parameter;
                TheodolitePanel theodolitePanel = new TheodolitePanel(acP);
                theodolitePanel.setTitleColor(Color.BLUE);
                theodolitePanel.getLongitudePositionPanel().setVisible(false);
                theodolitePanel.getLatitudePositionPanel().setVisible(false);
                theodolitePanel.getTimeZonePanel().setVisible(false);
                List items3 = (List)specialItems.get(acP);
                for (UDFParameterItem parameterItem : items3) {
                    ParameterItem srcParamItem = parameterItem.getRootSourceParameterItem();
                    if ("LO".equals(srcParamItem.getIdentifier())) {
                        theodolitePanel.getLongitudePositionPanel().setVisible(true);
                        theodolitePanel.setLongitudeLabel(parameterItem.getIdentifier().concat(": "));
                        continue;
                    }
                    if ("LA".equals(srcParamItem.getIdentifier())) {
                        theodolitePanel.getLatitudePositionPanel().setVisible(true);
                        theodolitePanel.setLatitudeLabel(parameterItem.getIdentifier().concat(": "));
                        continue;
                    }
                    if (!"TZ".equals(srcParamItem.getIdentifier())) continue;
                    theodolitePanel.getTimeZonePanel().setVisible(true);
                    theodolitePanel.setTimeZoneLabel(parameterItem.getIdentifier().concat(": "));
                }
                constraints2 = new GridBagConstraints();
                constraints2.gridx = 0;
                constraints2.gridy = i++;
                constraints2.fill = 2;
                constraints2.insets = new Insets(0, 0, 0, 0);
                constraints2.anchor = 17;
                this.contentPanel.add((Component)theodolitePanel, constraints2);
                this.subParamJPanels.put(acP, theodolitePanel);
                continue;
            }
            if (parameter instanceof AverageValueParameter) {
                AverageValueParameter avgP = (AverageValueParameter)parameter;
                items2 = (List)specialItems.get(avgP);
                AverageValueUDFPanel avgPanel = new AverageValueUDFPanel(avgP, items2);
                constraints2 = new GridBagConstraints();
                constraints2.gridx = 0;
                constraints2.gridy = i++;
                constraints2.fill = 2;
                constraints2.insets = new Insets(0, 0, 0, 0);
                constraints2.anchor = 17;
                this.contentPanel.add((Component)avgPanel, constraints2);
                this.subParamJPanels.put(avgP, avgPanel);
                continue;
            }
            if (parameter instanceof Analog) {
                Analog analog = (Analog)parameter;
                items2 = (List)specialItems.get(analog);
                GainOffsetValuePanel gainoffsetPanel = new GainOffsetValuePanel(analog, items2);
                gainoffsetPanel.setTitleColor(Color.BLUE);
                constraints2 = new GridBagConstraints();
                constraints2.gridx = 0;
                constraints2.gridy = i++;
                constraints2.fill = 2;
                constraints2.insets = new Insets(0, 0, 0, 0);
                constraints2.anchor = 17;
                this.contentPanel.add((Component)gainoffsetPanel, constraints2);
                this.subParamJPanels.put(analog, gainoffsetPanel);
                continue;
            }
            if (!(parameter instanceof StairsSwitchParameter) && !(parameter instanceof ComfortSwitchParameter)) continue;
            items = (List)specialItems.get(parameter);
            SwitchPanel panel = new SwitchPanel(parameter, items);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = i++;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.anchor = 17;
            this.contentPanel.add((Component)panel, constraints);
            this.subParamJPanels.put(parameter, panel);
        }
    }

    private static CamParameter getCamParameter(ParameterItem parameterItem) {
        CamParameter cp = null;
        if (!(parameterItem.getParameter() instanceof ClockParameter)) {
            return cp;
        }
        ClockParameter clockParameter = (ClockParameter)parameterItem.getParameter();
        String identifier = parameterItem.getIdentifier();
        if ("On0".equals(identifier) || "Off0".equals(identifier) || "D0".equals(identifier)) {
            cp = clockParameter.getCam(0);
        } else if ("On1".equals(identifier) || "Off1".equals(identifier) || "D1".equals(identifier)) {
            cp = clockParameter.getCam(1);
        } else if ("On2".equals(identifier) || "Off2".equals(identifier) || "D2".equals(identifier)) {
            cp = clockParameter.getCam(2);
        }
        return cp;
    }

    public DateParameterJPanel createParameterJPanel(Months paramVal, ParameterItem paramItem) {
        DateParameterJPanel panel = new DateParameterJPanel();
        panel.setParameter(paramVal);
        if (paramItem.getParameter() instanceof YearClockParameter) {
            String identifier = paramItem.getIdentifier();
            YearClockParameter parameter = (YearClockParameter)paramItem.getParameter();
            boolean monthly = parameter.isEveryMonth();
            boolean pulse = parameter.getPulse();
            if ("On".equals(identifier)) {
                panel.setMonthEnabled(!monthly);
            } else if ("Off".equals(identifier)) {
                panel.setMonthEnabled(!monthly && !pulse);
                panel.setDayEnabled(!pulse);
            }
        }
        return panel;
    }

    public ClockHoursPanel createParameterJPanel(ClockHours paramVal, ParameterItem paramItem) {
        return new ClockHoursPanel(paramVal);
    }

    public TimeValueOrReferencePanel createParameterJPanel(TimeUnit paramVal, ParameterItem paramItem) {
        Timer timer = ((TimeProtectionParameter)paramItem.getParameter()).getTimer();
        timer.setParamTime(paramVal);
        Hardware hw = ((BlockParameter)this.fParameterReference).getBlock().getHardware();
        TimeUnit[] availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
        timer.convertTimerTo(availableTimeUnits);
        TimeValueOrReferencePanel fTimeOrReferencePanel = new TimeValueOrReferencePanel(timer);
        Block block = ((BlockParameter)this.fParameterReference).getBlock();
        fTimeOrReferencePanel.setReferenceList(block.getWiringDiagram().getBlocksForReference(block, true));
        fTimeOrReferencePanel.setReferenceVisability(paramItem.getParameter().isValueOrReference());
        return fTimeOrReferencePanel;
    }

    public TimeValueOrReferencePanel createParameterJPanel(TimeValueProperties paramVal, ParameterItem paramItem) {
        Timer timer = null;
        BlockParameter param = paramItem.getParameter();
        if (param instanceof WipingRelayPECParameter) {
            timer = paramItem.getIdentifier().equals("TH") ? ((WipingRelayPECParameter)param).getTimer() : ((WipingRelayPECParameter)param).getBreakTimer();
        } else if (param instanceof StairsSwitchParameter) {
            if (paramItem.getIdentifier().equals("T!")) {
                timer = ((StairsSwitchParameter)param).getTimerToWarning();
            } else if (paramItem.getIdentifier().equals("T!L")) {
                timer = ((StairsSwitchParameter)param).getWarningTimer();
            } else if (paramItem.getIdentifier().equals("T")) {
                timer = ((StairsSwitchParameter)param).getTimer();
            }
        } else if (param instanceof ComfortSwitchParameter) {
            if (paramItem.getIdentifier().equals("T!")) {
                timer = ((ComfortSwitchParameter)param).getTimerToWarning();
            } else if (paramItem.getIdentifier().equals("T!L")) {
                timer = ((ComfortSwitchParameter)param).getWarningTimer();
            } else if (paramItem.getIdentifier().equals("TL")) {
                timer = ((ComfortSwitchParameter)param).getLTimer();
            } else if (paramItem.getIdentifier().equals("TH")) {
                timer = ((ComfortSwitchParameter)param).getHTimer();
            }
        } else if (param instanceof HoursCounterParameter) {
            if (paramItem.getIdentifier().equals("MI_h:m")) {
                timer = ((HoursCounterParameter)param).getMITimer();
            } else if (paramItem.getIdentifier().equals("OT_h:m")) {
                timer = ((HoursCounterParameter)param).getOTStartTimer();
            }
        } else if (param instanceof FrequencyParameter) {
            timer = ((FrequencyParameter)param).getTimeInterval();
        } else if (param instanceof Time2ProtectionParameter) {
            timer = paramItem.getIdentifier().equals("TH") ? ((Time2ProtectionParameter)param).getHTimer() : ((Time2ProtectionParameter)param).getLTimer();
        } else if (param instanceof TimeParameterInterface) {
            timer = ((TimeParameterInterface)((Object)param)).getTimer();
        }
        Hardware hw = ((BlockParameter)this.fParameterReference).getBlock().getHardware();
        if (timer == null) {
            return new TimeValueOrReferencePanel(new Timer());
        }
        if (!(param instanceof HoursCounterParameter)) {
            TimeUnit[] availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
            timer.convertTimerTo(availableTimeUnits);
        }
        TimeValueOrReferencePanel fTimeOrReferencePanel = null;
        fTimeOrReferencePanel = param instanceof HoursCounterParameter ? new TimeValueOrReferencePanel(timer){
            private static final long serialVersionUID = -7358141106162413150L;

            protected TimeUnit[] getTimeUnitsForReference() {
                return new TimeUnit[]{new UnlimitedHours(9999)};
            }
        } : new TimeValueOrReferencePanel(timer);
        Block block = ((BlockParameter)this.fParameterReference).getBlock();
        fTimeOrReferencePanel.setReferenceList(block.getWiringDiagram().getBlocksForReference(block, true));
        fTimeOrReferencePanel.setReferenceVisability(param.isValueOrReference());
        return fTimeOrReferencePanel;
    }

    public IntegerOrReferencePanel2 createParameterJPanel(IntegerOrBlockReference paramVal, ParameterItem paramItem) {
        Hardware hw = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram().getHardware();
        IntegerOrReferencePanel2 panel = new IntegerOrReferencePanel2(hw, paramItem);
        WiringDiagram wiringDiagram = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram();
        Block notIncluded = ((BlockParameter)this.fParameterReference).getBlock();
        ArrayList blocksForReference = wiringDiagram.getBlocksForReference(notIncluded, true);
        panel.setReferenceList(blocksForReference);
        panel.setProperties(paramVal);
        return panel;
    }

    public IntValuePanel createParameterJPanel(IntValueProperties paramVal, ParameterItem paramItem) {
        return new IntValuePanel(paramItem, paramVal);
    }

    public AnalogValuePanel createParameterJPanel(AnalogValueProperties paramVal, ParameterItem paramItem) {
        return new AnalogValuePanel(paramItem, paramVal);
    }

    public DoubleValuePanel createParameterJPanel(DoubleValueProperties paramVal, ParameterItem paramItem) {
        return new DoubleValuePanel(paramItem, paramVal);
    }

    public WeekDaysPanel createParameterJPanel(ModeUniversal paramVal, ParameterItem paramItem) {
        return new WeekDaysPanel();
    }

    public BorderJPanel createParameterJPanel(SoftkeyParameter.SwitchState paramVal, ParameterItem paramItem) {
        if (paramItem.getParameter() instanceof SoftkeyParameter) {
            return new SwitchStatePanel((SoftkeyParameter)paramItem.getParameter());
        }
        return new BorderJPanel();
    }

    public BorderJPanel createParameterJPanel(Integer paramVal, ParameterItem paramItem) {
        BlockParameter param = paramItem.getParameter();
        if (param instanceof AnalogFilterParameter) {
            return new IntegerParamPanel(paramVal, paramItem);
        }
        return this.getDefaultParamPanel(paramVal);
    }

    public BorderJPanel createParameterJPanel(TimeBase paramVal, ParameterItem paramItem) {
        if (paramItem.getParameter() instanceof StopWatchParameter) {
            return new TimeBasePanel(paramVal, paramItem);
        }
        return this.getDefaultParamPanel(paramVal);
    }

    public BorderJPanel createParameterJPanel(Boolean paramVal, ParameterItem paramItem) {
        if (paramItem.getParameter() instanceof MaxMinParameter) {
            return new BooleanParamPanel(paramItem, paramVal, Language.getString("panel.maxMinPanel.resetMaxMin", "When Enable=0,reset Min/Max"));
        }
        return this.getDefaultParamPanel(paramVal);
    }

    public DefaultParamPanel createParameterJPanel(Object paramVal, ParameterItem paramItem) {
        return this.getDefaultParamPanel(paramVal);
    }

    private DefaultParamPanel getDefaultParamPanel(Object paramVal) {
        DefaultParamPanel subParamJPanel = new DefaultParamPanel();
        subParamJPanel.setTitle("No such parameter");
        subParamJPanel.setTitleColor(Color.RED);
        subParamJPanel.add(new JLabel(paramVal.toString()));
        return subParamJPanel;
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        if (this.subParamJPanels == null) {
            return;
        }
        for (Component c : this.subParamJPanels.values()) {
            CodeBlock codeBlock = new CodeBlock(c, "loadFieldContents");
            try {
                codeBlock.execMethod();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchMethodError();
            }
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        if (this.subParamJPanels == null) {
            return;
        }
        for (Component c : this.subParamJPanels.values()) {
            CodeBlock codeBlock = new CodeBlock(c, "storeFieldContents");
            try {
                codeBlock.execMethod();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchMethodError();
            }
        }
    }

    public boolean checkChanged() {
        boolean changed = super.checkChanged();
        if (changed) {
            return changed;
        }
        if (this.subParamJPanels == null) {
            return false;
        }
        for (Component c : this.subParamJPanels.values()) {
            CodeBlock codeBlock = new CodeBlock(c, "checkChanged");
            try {
                changed = (Boolean)codeBlock.execMethod();
                if (!changed) continue;
                return changed;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchMethodError();
            }
        }
        return changed;
    }

    public static class DefaultParamPanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;

        public void loadFieldContents() {
        }

        public boolean checkChanged() {
            return false;
        }

        public void storeFieldContents() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SwitchPanel
    extends JPanel
    implements PropertyChangeListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private TimeValueOrReferencePanel fTimeOrReferencePanel;
        private TimeOrReferenceSycnPanel fTimeToWarningPanel;
        private TimeOrReferenceSycnPanel fWarningTimePanel;
        private BorderJPanel fTimeToWarningBorderPanel;
        private BorderJPanel fWarningTimeBorderPanel;
        private JCheckBox fUseDefault;
        private BlockParameter fBlockParameter;
        private TimeUnit fTimeUnit;

        public SwitchPanel(BlockParameter parameter, List<UDFParameterItem> items) {
            JPanel panel;
            this.setLayout(new GridBagLayout());
            this.fBlockParameter = parameter;
            for (int i = 0; i < items.size(); ++i) {
                Block lBlock;
                TimeUnit[] availableTimeUnits;
                Hardware hw;
                ParameterItem srcItem = items.get(i).getSourceParameterItem();
                if (!(srcItem.getValue() instanceof TimeValueProperties)) continue;
                String identifier = items.get(i).getIdentifier();
                if (srcItem.getIdentifier().equals("T") || srcItem.getIdentifier().equals("TH")) {
                    this.fTimeOrReferencePanel = UDFBlockPanel.this.createParameterJPanel((TimeValueProperties)srcItem.getValue(), srcItem);
                    this.fTimeOrReferencePanel.setTitle(identifier);
                    this.fTimeOrReferencePanel.addPropertyChangeListener(TimeValueOrReferencePanel.TIME_UNIT_CHANGE_EVENT_NAME, this);
                    this.fTimeOrReferencePanel.addReferenceTimeUnitChangedListener(this);
                    continue;
                }
                if (srcItem.getIdentifier().equals("T!")) {
                    hw = this.fBlockParameter.getBlock().getHardware();
                    availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
                    Timer timerToWarning = null;
                    if (this.fBlockParameter instanceof StairsSwitchParameter) {
                        timerToWarning = ((StairsSwitchParameter)this.fBlockParameter).getTimerToWarning();
                    } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                        timerToWarning = ((ComfortSwitchParameter)this.fBlockParameter).getTimerToWarning();
                    }
                    timerToWarning.convertTimerTo(availableTimeUnits);
                    lBlock = this.fBlockParameter.getBlock();
                    this.fTimeToWarningPanel = new TimeOrReferenceSycnPanel(timerToWarning);
                    this.fTimeToWarningPanel.setName("TimerToWarning");
                    this.fTimeToWarningPanel.setBounds(17, 106, 291, 60);
                    this.fTimeToWarningPanel.setReferenceList(lBlock.getWiringDiagram().getBlocksForReference(lBlock, true));
                    this.fTimeToWarningPanel.setReferenceVisability(UDFBlockPanel.this.fParameterReference.isValueOrReference());
                    this.fTimeToWarningBorderPanel = new BorderJPanel(new FlowLayout(0));
                    this.fTimeToWarningBorderPanel.setTitle(identifier);
                    this.fTimeToWarningBorderPanel.add(this.fTimeToWarningPanel);
                    continue;
                }
                if (!srcItem.getIdentifier().equals("T!L")) continue;
                hw = this.fBlockParameter.getBlock().getHardware();
                availableTimeUnits = (TimeUnit[])hw.getProperty("availableTimeUnits");
                Timer warningTimer = null;
                if (this.fBlockParameter instanceof StairsSwitchParameter) {
                    warningTimer = ((StairsSwitchParameter)this.fBlockParameter).getWarningTimer();
                } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                    warningTimer = ((ComfortSwitchParameter)this.fBlockParameter).getWarningTimer();
                }
                warningTimer.convertTimerTo(availableTimeUnits);
                lBlock = this.fBlockParameter.getBlock();
                this.fWarningTimePanel = new TimeOrReferenceSycnPanel(warningTimer);
                this.fWarningTimePanel.setName("WarningTimer");
                this.fWarningTimePanel.setBounds(17, 106, 291, 60);
                this.fWarningTimePanel.setReferenceList(lBlock.getWiringDiagram().getBlocksForReference(lBlock, true));
                this.fWarningTimePanel.setReferenceVisability(UDFBlockPanel.this.fParameterReference.isValueOrReference());
                this.fWarningTimeBorderPanel = new BorderJPanel(new FlowLayout(0));
                this.fWarningTimeBorderPanel.setTitle(identifier);
                this.fWarningTimeBorderPanel.add(this.fWarningTimePanel);
            }
            int gridy = 0;
            GridBagConstraints gbc = null;
            if (this.fTimeOrReferencePanel != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 17;
                this.add((Component)this.fTimeOrReferencePanel, gbc);
            }
            if (this.fTimeToWarningBorderPanel != null) {
                panel = new JPanel(new FlowLayout(0));
                this.fUseDefault = new JCheckBox(Language.getString("stairsSwitch.useDefaultWarningproperties", "Use default Warning"));
                this.fUseDefault.addActionListener(new UseDefaultButtonListener());
                panel.add(this.fUseDefault);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 17;
                this.add((Component)panel, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 17;
                this.add((Component)this.fTimeToWarningBorderPanel, gbc);
            }
            if (this.fWarningTimeBorderPanel != null) {
                if (this.fUseDefault == null) {
                    panel = new JPanel(new FlowLayout(0));
                    this.fUseDefault = new JCheckBox(Language.getString("stairsSwitch.useDefaultWarningproperties", "Use default Warning"));
                    this.fUseDefault.addActionListener(new UseDefaultButtonListener());
                    panel.add(this.fUseDefault);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = gridy++;
                    gbc.weightx = 1.0;
                    gbc.weighty = 1.0;
                    gbc.anchor = 17;
                    this.add((Component)panel, gbc);
                }
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 17;
                this.add((Component)this.fWarningTimeBorderPanel, gbc);
            }
        }

        public void loadFieldContents() {
            if (this.fTimeOrReferencePanel != null) {
                this.fTimeOrReferencePanel.loadFieldContents();
            }
            if (this.fTimeToWarningPanel != null) {
                this.fTimeToWarningPanel.loadFieldContents();
            }
            if (this.fWarningTimePanel != null) {
                this.fWarningTimePanel.loadFieldContents();
            }
            if (this.fBlockParameter instanceof StairsSwitchParameter) {
                this.fTimeUnit = ((StairsSwitchParameter)this.fBlockParameter).getParamTime().getCurrentValue();
            } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                this.fTimeUnit = ((ComfortSwitchParameter)this.fBlockParameter).getHTimer().getParamTime();
            }
            boolean useDefaultWarningValues = false;
            if (this.fBlockParameter instanceof StairsSwitchParameter) {
                useDefaultWarningValues = ((StairsSwitchParameter)this.fBlockParameter).isDefaultWarningUsed();
            } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                useDefaultWarningValues = ((ComfortSwitchParameter)this.fBlockParameter).isDefaultWarningUsed();
            }
            this.fUseDefault.setSelected(useDefaultWarningValues);
            this.setWarningInputs(!useDefaultWarningValues);
        }

        private void setWarningInputs(boolean enable) {
            if (this.fTimeToWarningBorderPanel != null) {
                this.fTimeToWarningBorderPanel.setEnabled(enable);
                this.fTimeToWarningPanel.setEnabled(enable);
            }
            if (this.fWarningTimeBorderPanel != null) {
                this.fWarningTimeBorderPanel.setEnabled(enable);
                this.fWarningTimePanel.setEnabled(enable);
            }
        }

        public boolean checkChanged() {
            if (this.fTimeOrReferencePanel != null && this.fTimeOrReferencePanel.checkChanged()) {
                return true;
            }
            if (this.fTimeToWarningPanel != null && this.fTimeToWarningPanel.checkChanged()) {
                return true;
            }
            return this.fWarningTimePanel != null && this.fWarningTimePanel.checkChanged();
        }

        public boolean checkFieldContents() {
            if (this.fTimeOrReferencePanel != null && !this.fTimeOrReferencePanel.checkFieldContents()) {
                return false;
            }
            if (this.fTimeToWarningPanel != null && !this.fTimeToWarningPanel.checkFieldContents()) {
                return false;
            }
            return this.fWarningTimePanel == null || this.fWarningTimePanel.checkFieldContents();
        }

        public void storeFieldContents() {
            if (this.fTimeOrReferencePanel != null) {
                this.fTimeOrReferencePanel.storeFieldContents();
            }
            if (this.fTimeToWarningPanel != null) {
                Timer timerToWarning = null;
                if (this.fBlockParameter instanceof StairsSwitchParameter) {
                    timerToWarning = ((StairsSwitchParameter)this.fBlockParameter).getTimerToWarning();
                } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                    timerToWarning = ((ComfortSwitchParameter)this.fBlockParameter).getTimerToWarning();
                }
                timerToWarning.setParamTime(0, 0, this.fTimeUnit.getUnitKey());
                this.fTimeToWarningPanel.storeFieldContents();
            }
            if (this.fWarningTimePanel != null) {
                Timer warningTimer = null;
                if (this.fBlockParameter instanceof StairsSwitchParameter) {
                    warningTimer = ((StairsSwitchParameter)this.fBlockParameter).getWarningTimer();
                } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                    warningTimer = ((ComfortSwitchParameter)this.fBlockParameter).getWarningTimer();
                }
                warningTimer.setParamTime(this.fTimeUnit);
                this.fWarningTimePanel.storeFieldContents();
            }
        }

        protected void setDefaultWarningValues() {
            if (this.fTimeToWarningPanel != null) {
                this.fTimeToWarningPanel.setReferenceAndButton(false);
                if (this.fBlockParameter instanceof StairsSwitchParameter) {
                    this.fTimeToWarningPanel.setTimeUnit(((StairsSwitchParameter)this.fBlockParameter).getDefaultTimeToWarning(this.fTimeUnit));
                } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                    this.fTimeToWarningPanel.setTimeUnit(TimeUnit.getNewTimeObject(this.fTimeUnit.getUnitKey()));
                }
            }
            if (this.fWarningTimePanel != null) {
                this.fWarningTimePanel.setReferenceAndButton(false);
                if (this.fBlockParameter instanceof StairsSwitchParameter) {
                    this.fWarningTimePanel.setTimeUnit(((StairsSwitchParameter)this.fBlockParameter).getDefaultWarningTime(this.fTimeUnit));
                } else if (this.fBlockParameter instanceof ComfortSwitchParameter) {
                    this.fWarningTimePanel.setTimeUnit(TimeUnit.getNewTimeObject(this.fTimeUnit.getUnitKey()));
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fTimeUnit = (TimeUnit)evt.getNewValue();
            this.setTimeUnits();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() instanceof JComboBox && e.getStateChange() == 1 && e.getItem() instanceof TimeUnit) {
                this.fTimeUnit = (TimeUnit)e.getItem();
                this.setTimeUnits();
            }
        }

        private void setTimeUnits() {
            this.setWarningLabels(this.fTimeUnit);
            if (this.fUseDefault.isSelected()) {
                this.setDefaultWarningValues();
            }
        }

        private void setWarningLabels(TimeUnit value) {
            this.fTimeToWarningPanel.setTimeUnitKey(value);
            this.fWarningTimePanel.setTimeUnitKey(value);
        }

        public class UseDefaultButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent ae) {
                if (SwitchPanel.this.fUseDefault.isSelected()) {
                    SwitchPanel.this.setDefaultWarningValues();
                    SwitchPanel.this.setWarningInputs(false);
                } else {
                    SwitchPanel.this.setWarningInputs(true);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AverageValueUDFPanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        AverageValuePanel.AverageValueParameterPanel fAverageValueParameterPanel = null;

        public AverageValueUDFPanel(AverageValueParameter avgP, List<UDFParameterItem> items) {
            this.setLayout(new GridBagLayout());
            this.fAverageValueParameterPanel = new AverageValuePanel.AverageValueParameterPanel(avgP);
            this.fAverageValueParameterPanel.getSampleNumPanel().setVisible(false);
            this.fAverageValueParameterPanel.getSampleTimePanel().setVisible(false);
            for (UDFParameterItem parameterItem : items) {
                ParameterItem srcParamItem = parameterItem.getRootSourceParameterItem();
                if ("SN".equals(srcParamItem.getIdentifier())) {
                    this.fAverageValueParameterPanel.getSampleNumPanel().setVisible(true);
                    this.fAverageValueParameterPanel.getSampleNumLabel().setText(parameterItem.getIdentifier().concat(": "));
                    this.fAverageValueParameterPanel.getSampleNumLabel().setForeground(Color.BLUE);
                    continue;
                }
                if (!"ST".equals(srcParamItem.getIdentifier())) continue;
                this.fAverageValueParameterPanel.getSampleTimePanel().setVisible(true);
                this.fAverageValueParameterPanel.getSampleTimeLabel().setText(parameterItem.getIdentifier().concat(": "));
                this.fAverageValueParameterPanel.getSampleTimeLabel().setForeground(Color.BLUE);
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 17;
            this.add((Component)this.fAverageValueParameterPanel, gbc);
        }

        public void loadFieldContents() {
            this.fAverageValueParameterPanel.loadFieldContents();
        }

        public boolean checkChanged() {
            return this.fAverageValueParameterPanel.checkChanged();
        }

        public boolean checkFieldContents() {
            return this.fAverageValueParameterPanel.checkFieldContents();
        }

        public void storeFieldContents() {
            this.fAverageValueParameterPanel.storeFieldContents();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GainOffsetValuePanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        protected MeasurementPanel.SensorPanel fSensorPanel;

        public GainOffsetValuePanel(Analog analog, List<UDFParameterItem> items) {
            this.setLayout(new GridBagLayout());
            this.fSensorPanel = this.getSensorPanel(analog.getMeasurement().getSensor());
            if (this.fSensorPanel instanceof MeasurementPanel.SensorAdjustableMeasurementRangePanel) {
                ((MeasurementPanel.SensorAdjustableMeasurementRangePanel)this.fSensorPanel).getMeasurementRangePanel().setVisible(false);
                ((MeasurementPanel.SensorAdjustableMeasurementRangePanel)this.fSensorPanel).getMessageLabel().setVisible(false);
            }
            this.fSensorPanel.setSensor(analog.getMeasurement().getSensor());
            this.fSensorPanel.getLblGain().setVisible(false);
            this.fSensorPanel.getLblOffset().setVisible(false);
            this.fSensorPanel.getGainSpinner().setVisible(false);
            this.fSensorPanel.getOffsetSpinner().setVisible(false);
            for (UDFParameterItem item : items) {
                ParameterItem srcItem = item.getSourceParameterItem();
                if (srcItem.getIdentifier().equals("A")) {
                    this.fSensorPanel.getLblGain().setVisible(true);
                    this.fSensorPanel.getLblGain().setText(item.getIdentifier().concat(": "));
                    this.fSensorPanel.getLblGain().setForeground(Color.BLUE);
                    this.fSensorPanel.getGainSpinner().setVisible(true);
                    continue;
                }
                if (!srcItem.getIdentifier().equals("B")) continue;
                this.fSensorPanel.getLblOffset().setVisible(true);
                this.fSensorPanel.getLblOffset().setText(item.getIdentifier().concat(": "));
                this.fSensorPanel.getLblOffset().setForeground(Color.BLUE);
                this.fSensorPanel.getOffsetSpinner().setVisible(true);
            }
            this.fSensorPanel.setGainOffsetPanelBorder(new EmptyBorder(0, 0, 0, 0));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 17;
            this.add((Component)this.fSensorPanel, gbc);
        }

        public void loadFieldContents() throws ProgramException {
            this.fSensorPanel.loadFieldContents();
        }

        public boolean checkFieldContents() {
            return this.fSensorPanel.checkFieldContents();
        }

        public boolean checkChanged() {
            return this.fSensorPanel.checkChanged();
        }

        public void storeFieldContents() {
            this.fSensorPanel.checkFieldContents();
        }

        private MeasurementPanel.SensorPanel getSensorPanel(Measurement.Sensor sensor) {
            MeasurementPanel.SensorPanel sensorPanel = null;
            if (sensor.getClass() == Measurement.Sensor0to10V.class) {
                sensorPanel = new MeasurementPanel.SensorAdjustableMeasurementRangePanel();
            }
            if (sensor.getClass() == Measurement.Sensor4to20mA.class) {
                sensorPanel = new MeasurementPanel.SensorAdjustableMeasurementRangePanel();
            }
            if (sensor.getClass() == Measurement.Sensor0to20mA.class) {
                sensorPanel = new MeasurementPanel.SensorAdjustableMeasurementRangePanel();
            }
            if (sensor.getClass() == Measurement.SensorPT100.class) {
                sensorPanel = new MeasurementPanel.SensorPT100Panel();
            }
            if (sensor.getClass() == Measurement.SensorPT100Invers.class) {
                sensorPanel = new MeasurementPanel.SensorPT100Panel();
            }
            if (sensorPanel == null) {
                sensorPanel = new MeasurementPanel.SensorPanel();
            }
            return sensorPanel;
        }
    }

    public static class BooleanParamPanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox fCheckBox = null;
        private Boolean fCheckValue = false;
        private BlockParameter param = null;

        public BooleanParamPanel(ParameterItem item, Boolean paramVal, String text) {
            this.fCheckBox = new JCheckBox(text);
            this.add(this.fCheckBox);
            this.fCheckValue = paramVal;
            this.param = item.getParameter();
        }

        public void loadFieldContents() {
            this.fCheckBox.setSelected(this.fCheckValue);
        }

        public boolean checkChanged() {
            return this.fCheckValue.booleanValue() != this.fCheckBox.isSelected();
        }

        public void storeFieldContents() {
            if (this.param instanceof MaxMinParameter) {
                ((MaxMinParameter)this.param).setResetMaxMin(this.fCheckBox.isSelected());
            }
        }
    }

    public static class TimeBasePanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox fTimeBaseCombo = null;
        protected BlockParameter fParameterReference;

        public TimeBasePanel(TimeBase value, ParameterItem paramItem) {
            this.fParameterReference = paramItem.getParameter();
            this.fTimeBaseCombo = new JComboBox();
            DefaultComboBoxModel<TimeBase> comboBoxModel = null;
            if (this.fParameterReference instanceof StopWatchParameter) {
                comboBoxModel = new DefaultComboBoxModel<TimeBase>(TimeBase.getDefaultTimeBases());
            }
            this.fTimeBaseCombo.setModel(comboBoxModel);
            this.fTimeBaseCombo.setRenderer(new StopWatchPanel.TimeBaseListCellRender());
            this.add(this.fTimeBaseCombo);
            this.setPreferredSize(new Dimension(260, 60));
        }

        public void loadFieldContents() {
            if (this.fParameterReference instanceof StopWatchParameter) {
                ComboBoxModel comboBoxModel = this.fTimeBaseCombo.getModel();
                int modelSize = comboBoxModel.getSize();
                for (int i = 0; i < modelSize; ++i) {
                    if (((TimeBase)comboBoxModel.getElementAt(i)).getTimeBaseKey() != ((StopWatchParameter)this.fParameterReference).getOutputTimeBase().getTimeBaseKey()) continue;
                    this.fTimeBaseCombo.setSelectedIndex(i);
                    break;
                }
            }
        }

        public boolean checkChanged() {
            return this.fParameterReference instanceof StopWatchParameter && ((StopWatchParameter)this.fParameterReference).getOutputTimeBase().getTimeBaseKey() != ((TimeBase)this.fTimeBaseCombo.getSelectedItem()).getTimeBaseKey();
        }

        public void storeFieldContents() {
            if (this.fParameterReference instanceof StopWatchParameter) {
                ((StopWatchParameter)this.fParameterReference).getOutputTimeBase().setTimeBaseKey(((TimeBase)this.fTimeBaseCombo.getSelectedItem()).getTimeBaseKey());
            }
        }
    }

    public static class IntegerParamPanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private BlockParameter parameterReference = null;
        private Integer currentValue = null;
        Component component = null;

        public IntegerParamPanel(Integer value, ParameterItem paramItem) {
            this.parameterReference = paramItem.getParameter();
            this.currentValue = value;
            if (this.parameterReference instanceof AnalogFilterParameter) {
                this.component = new JComboBox();
                for (int eachItem : AnalogFilterPanel.fMaxTimeItem) {
                    ((JComboBox)this.component).addItem(new Integer(eachItem));
                }
                this.add(this.component);
            }
        }

        public void loadFieldContents() {
            if (this.parameterReference instanceof AnalogFilterParameter) {
                ((JComboBox)this.component).setSelectedItem(this.currentValue);
            }
        }

        public boolean checkChanged() {
            if (this.component == null) {
                return false;
            }
            if (this.parameterReference instanceof AnalogFilterParameter && !((JComboBox)this.component).getSelectedItem().equals(this.currentValue)) {
                return true;
            }
            return true;
        }

        public void storeFieldContents() {
            if (this.component == null) {
                return;
            }
            if (this.parameterReference instanceof AnalogFilterParameter) {
                ((AnalogFilterParameter)this.parameterReference).setSampleNumber((Integer)((JComboBox)this.component).getSelectedItem());
            }
        }
    }

    public static class SwitchStatePanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private ButtonGroup ivjStateGroup = null;
        private JRadioButton ivjOffButton = null;
        private JRadioButton ivjOnButton = null;
        protected SoftkeyParameter fParameterReference;

        public SwitchStatePanel(SoftkeyParameter parameter) {
            this.fParameterReference = parameter;
            this.add((Component)this.getOnButton(), this.getOnButton().getName());
            this.add((Component)this.getOffButton(), this.getOffButton().getName());
        }

        private JRadioButton getOffButton() {
            if (this.ivjOffButton == null) {
                try {
                    this.ivjOffButton = new JRadioButton();
                    this.ivjOffButton.setName("OffButton");
                    this.ivjOffButton.setSelected(true);
                    this.ivjOffButton.setText("Off");
                    this.ivjOffButton.setBounds(6, 42, 300, 22);
                    this.getStateGroup().add(this.ivjOffButton);
                }
                catch (Throwable ivjExc) {
                    this.handleException(ivjExc);
                }
            }
            return this.ivjOffButton;
        }

        private JRadioButton getOnButton() {
            if (this.ivjOnButton == null) {
                try {
                    this.ivjOnButton = new JRadioButton();
                    this.ivjOnButton.setName("OnButton");
                    this.ivjOnButton.setText("On");
                    this.ivjOnButton.setBounds(6, 20, 300, 22);
                    this.getStateGroup().add(this.ivjOnButton);
                }
                catch (Throwable ivjExc) {
                    this.handleException(ivjExc);
                }
            }
            return this.ivjOnButton;
        }

        private ButtonGroup getStateGroup() {
            if (this.ivjStateGroup == null) {
                try {
                    this.ivjStateGroup = new ButtonGroup();
                }
                catch (Throwable ivjExc) {
                    this.handleException(ivjExc);
                }
            }
            return this.ivjStateGroup;
        }

        public void loadFieldContents() {
            if (this.fParameterReference.isOn()) {
                this.getOnButton().setSelected(true);
            } else {
                this.getOffButton().setSelected(true);
            }
        }

        public boolean checkChanged() {
            return this.getOnButton().isSelected() ? !this.fParameterReference.isOn() : this.fParameterReference.isOn();
        }

        public void storeFieldContents() {
            if (this.getOnButton().isSelected()) {
                this.fParameterReference.setSwitchState(Boolean.TRUE);
            } else {
                this.fParameterReference.setSwitchState(Boolean.FALSE);
            }
        }

        private void handleException(Throwable exception) {
        }
    }

    public static class IntegerOrReferencePanel2
    extends IntegerOrReferencePanel {
        private static final long serialVersionUID = -7050614477409452656L;
        private ParameterItem fParameterItem = null;

        public IntegerOrReferencePanel2(Hardware hw, ParameterItem item) {
            this.fParameterItem = item;
        }

        public void loadFieldContents() {
            this.setProperties((IntegerOrBlockReference)this.fParameterItem.getValue());
        }

        public void storeFieldContents() {
            if (this.fParameterItem.getValue() instanceof AnalogOrBlockReference) {
                AnalogOrBlockReference abr = new AnalogOrBlockReference();
                abr.setIntValueProperties(this.getValue().getIntValueProperties());
                abr.setIntValue(this.getValue().getValue());
                if (this.getValue().isReference()) {
                    abr.setReference(this.getValue().getReference());
                }
                this.fParameterItem.setValue(abr);
            } else {
                this.fParameterItem.setValue(this.getValue());
            }
        }

        public boolean checkChanged() {
            return super.checkChanged();
        }
    }

    public static class WeekDaysPanel
    extends BorderJPanel {
        private static final long serialVersionUID = -9147186402076703354L;
        private JCheckBox ivjModeFriday = null;
        private JCheckBox ivjModeMonday = null;
        private JCheckBox ivjModeSaturday = null;
        private JCheckBox ivjModeSunday = null;
        private JCheckBox ivjModeThursday = null;
        private JCheckBox ivjModeTuesday = null;
        private JCheckBox ivjModeWednesday = null;
        private Integer fLogoMode = 0;
        private CamParameter fCamParameter = null;
        private transient JCheckBox[] fDays = new JCheckBox[]{this.getModeSunday(), this.getModeMonday(), this.getModeTuesday(), this.getModeWednesday(), this.getModeThursday(), this.getModeFriday(), this.getModeSaturday()};

        public WeekDaysPanel() {
            for (int i = 0; i < this.fDays.length; ++i) {
                this.add((Component)this.fDays[i], this.fDays[i].getName());
            }
        }

        public WeekDaysPanel(CamParameter camParameter, Integer logoMode) {
            this.fCamParameter = camParameter;
            this.fLogoMode = logoMode;
            this.add((Component)this.getModeMonday(), this.getModeMonday().getName());
            this.add((Component)this.getModeTuesday(), this.getModeTuesday().getName());
            this.add((Component)this.getModeWednesday(), this.getModeWednesday().getName());
            this.add((Component)this.getModeThursday(), this.getModeThursday().getName());
            this.add((Component)this.getModeFriday(), this.getModeFriday().getName());
            this.add((Component)this.getModeSaturday(), this.getModeSaturday().getName());
            this.add((Component)this.getModeSunday(), this.getModeSunday().getName());
        }

        public void loadFieldContents() {
            this.fLogoMode = this.fCamParameter.getLogoMode();
            CheckboxListener checkboxItemListener = new CheckboxListener();
            for (int i = 0; i < 7; ++i) {
                boolean value = (this.fLogoMode & 1 << i) > 0;
                this.fDays[i].removeItemListener(checkboxItemListener);
                this.fDays[i].setSelected(value);
                this.fDays[i].addItemListener(checkboxItemListener);
            }
        }

        public void storeFieldContents() {
            this.fCamParameter.setLogoMode(this.fLogoMode);
        }

        public boolean checkChanged() {
            return this.fCamParameter.getLogoMode() != this.fLogoMode.intValue();
        }

        private JCheckBox getModeFriday() {
            if (this.ivjModeFriday == null) {
                this.ivjModeFriday = new JCheckBox();
                this.ivjModeFriday.setName("ModeFriday");
                this.ivjModeFriday.setText("Friday");
                this.ivjModeFriday.setBounds(15, 114, 100, 25);
            }
            return this.ivjModeFriday;
        }

        private JCheckBox getModeMonday() {
            if (this.ivjModeMonday == null) {
                this.ivjModeMonday = new JCheckBox();
                this.ivjModeMonday.setName("ModeMonday");
                this.ivjModeMonday.setText("Monday");
                this.ivjModeMonday.setBounds(15, 18, 100, 25);
            }
            return this.ivjModeMonday;
        }

        private JCheckBox getModeSaturday() {
            if (this.ivjModeSaturday == null) {
                this.ivjModeSaturday = new JCheckBox();
                this.ivjModeSaturday.setName("ModeSaturday");
                this.ivjModeSaturday.setText("Saturday");
                this.ivjModeSaturday.setBounds(15, 138, 100, 25);
            }
            return this.ivjModeSaturday;
        }

        private JCheckBox getModeSunday() {
            if (this.ivjModeSunday == null) {
                this.ivjModeSunday = new JCheckBox();
                this.ivjModeSunday.setName("ModeSunday");
                this.ivjModeSunday.setText("Sunday");
                this.ivjModeSunday.setBounds(15, 162, 100, 25);
            }
            return this.ivjModeSunday;
        }

        private JCheckBox getModeThursday() {
            if (this.ivjModeThursday == null) {
                this.ivjModeThursday = new JCheckBox();
                this.ivjModeThursday.setName("ModeThursday");
                this.ivjModeThursday.setText("Thursday");
                this.ivjModeThursday.setBounds(15, 90, 100, 25);
            }
            return this.ivjModeThursday;
        }

        private JCheckBox getModeTuesday() {
            if (this.ivjModeTuesday == null) {
                this.ivjModeTuesday = new JCheckBox();
                this.ivjModeTuesday.setName("ModeTuesday");
                this.ivjModeTuesday.setText("Tuesday");
                this.ivjModeTuesday.setBounds(15, 42, 100, 25);
            }
            return this.ivjModeTuesday;
        }

        private JCheckBox getModeWednesday() {
            if (this.ivjModeWednesday == null) {
                this.ivjModeWednesday = new JCheckBox();
                this.ivjModeWednesday.setName("ModeWednesday");
                this.ivjModeWednesday.setText("Wednesday");
                this.ivjModeWednesday.setBounds(15, 66, 100, 25);
            }
            return this.ivjModeWednesday;
        }

        class CheckboxListener
        implements ItemListener {
            CheckboxListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                ItemSelectable source = e.getItemSelectable();
                if (source == WeekDaysPanel.this.getModeMonday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 2;
                } else if (source == WeekDaysPanel.this.getModeTuesday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 4;
                } else if (source == WeekDaysPanel.this.getModeWednesday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 8;
                } else if (source == WeekDaysPanel.this.getModeThursday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 0x10;
                } else if (source == WeekDaysPanel.this.getModeFriday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 0x20;
                } else if (source == WeekDaysPanel.this.getModeSaturday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 0x40;
                } else if (source == WeekDaysPanel.this.getModeSunday()) {
                    WeekDaysPanel.this.fLogoMode = WeekDaysPanel.this.fLogoMode ^ 1;
                }
            }
        }
    }

    public static class AnalogValuePanel
    extends BorderJPanel {
        private static final long serialVersionUID = -626717129275766389L;
        EditableNumericSpinner fEditableNumericSpinner = new EditableNumericSpinner();
        AnalogValueProperties fAnalogValueProperties = null;
        ParameterItem fParameterItem = null;

        public AnalogValuePanel(ParameterItem item, AnalogValueProperties paramVal) {
            this.fParameterItem = item;
            this.fAnalogValueProperties = paramVal;
            this.add(this.fEditableNumericSpinner);
            this.setPreferredSize(new Dimension(260, 60));
        }

        public void loadFieldContents() {
            this.fEditableNumericSpinner.setProperties(this.fAnalogValueProperties);
        }

        public void storeFieldContents() {
            this.fAnalogValueProperties.setCurrentValue(this.fEditableNumericSpinner.getValueProperties().getCurrentValue());
            this.fParameterItem.setValue(this.fAnalogValueProperties);
        }

        public boolean checkChanged() {
            return this.fEditableNumericSpinner.checkChanged();
        }
    }

    public static class IntValuePanel
    extends BorderJPanel {
        private static final long serialVersionUID = -626717129275766389L;
        EditableNumericSpinner fEditableNumericSpinner = new EditableNumericSpinner();
        IntValueProperties fIntValueProperties = null;
        ParameterItem fParameterItem = null;

        public IntValuePanel(ParameterItem item, IntValueProperties paramVal) {
            this.fParameterItem = item;
            this.fIntValueProperties = paramVal;
            this.fEditableNumericSpinner.setProperties(paramVal);
            this.add(this.fEditableNumericSpinner);
            this.setPreferredSize(new Dimension(260, 60));
        }

        public void loadFieldContents() {
            this.fEditableNumericSpinner.setProperties(this.fIntValueProperties);
        }

        public void storeFieldContents() {
            this.fParameterItem.setValue(this.fEditableNumericSpinner.getValueProperties());
        }

        public boolean checkChanged() {
            return this.fEditableNumericSpinner.checkChanged();
        }
    }

    public static class DoubleValuePanel
    extends BorderJPanel {
        private static final long serialVersionUID = 2365511657480612679L;
        DoubleNumericSpinner fDoubleNumericSpinner = new DoubleNumericSpinner();
        DoubleValueProperties fDoubleValueProperties = null;
        ParameterItem fParameterItem = null;

        public DoubleValuePanel(ParameterItem item, DoubleValueProperties paramVal) {
            this.fParameterItem = item;
            this.fDoubleValueProperties = paramVal;
            this.fDoubleNumericSpinner.setProperties(paramVal);
            this.add(this.fDoubleNumericSpinner);
        }

        public void loadFieldContents() {
            this.fDoubleNumericSpinner.setProperties(this.fDoubleValueProperties);
        }

        public void storeFieldContents() {
            this.fParameterItem.setValue(this.fDoubleNumericSpinner.getProperties());
        }

        public boolean checkChanged() {
            return this.fDoubleNumericSpinner.checkChanged();
        }
    }

    public static class CamParameterPanel
    extends JPanel {
        private static final long serialVersionUID = 2572085770200399356L;
        private UDFParameterItem fWeekdayItem = null;
        private UDFParameterItem fOnTimeItem = null;
        private UDFParameterItem fOffTimeItem = null;
        private CamParameter fCamParameter = null;
        private WeekDaysPanel fWeekDaysPanel = null;
        private CamTimePanel fOnTimePanel = null;
        private CamTimePanel fOffTimePanel = null;
        private Integer fLogoMode = new Integer(0);

        public CamParameterPanel(CamParameter parameter, UDFParameterItem weekdayItem, UDFParameterItem onTimeItem, UDFParameterItem offItem) {
            this.fCamParameter = parameter;
            this.fWeekdayItem = weekdayItem;
            this.fOnTimeItem = onTimeItem;
            this.fOffTimeItem = offItem;
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = null;
            this.fLogoMode = new Integer(this.fCamParameter.getLogoMode());
            int gridy = 0;
            if (this.fWeekdayItem != null) {
                this.fWeekDaysPanel = new WeekDaysPanel(this.fCamParameter, this.fLogoMode);
                this.fWeekDaysPanel.setTitle(this.fWeekdayItem.getIdentifier());
                this.fWeekDaysPanel.setLayout(new FlowLayout(0));
                constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = gridy++;
                constraints.fill = 2;
                constraints.insets = new Insets(0, 0, 0, 0);
                constraints.anchor = 17;
                this.add((Component)this.fWeekDaysPanel, constraints);
            }
            if (this.fOnTimeItem != null) {
                this.fOnTimePanel = new CamTimePanel(this.fOnTimeItem.getSourceParameterItem(), (ClockHours)this.fOnTimeItem.getValue(), this.fLogoMode);
                this.fOnTimePanel.setTitle(this.fOnTimeItem.getIdentifier());
                this.fOnTimePanel.setLayout(new FlowLayout(0));
                constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = gridy++;
                constraints.fill = 2;
                constraints.insets = new Insets(0, 0, 0, 0);
                constraints.anchor = 17;
                this.add((Component)this.fOnTimePanel, constraints);
            }
            if (this.fOffTimeItem != null) {
                this.fOffTimePanel = new CamTimePanel(this.fOffTimeItem.getSourceParameterItem(), (ClockHours)this.fOffTimeItem.getValue(), this.fLogoMode);
                this.fOffTimePanel.setTitle(this.fOffTimeItem.getIdentifier());
                this.fOffTimePanel.setLayout(new FlowLayout(0));
                constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = gridy++;
                constraints.fill = 2;
                constraints.insets = new Insets(0, 0, 0, 0);
                constraints.anchor = 17;
                this.add((Component)this.fOffTimePanel, constraints);
                ClockParameter clocParameter = (ClockParameter)this.fOffTimeItem.getSourceParameterItem().getParameter();
                this.fOffTimePanel.setPulseMode(clocParameter.getPulse());
            }
        }

        public void loadFieldContents() {
            this.fLogoMode = this.fCamParameter.getLogoMode();
            if (this.fWeekdayItem != null) {
                this.fWeekDaysPanel.loadFieldContents();
            }
            if (this.fOnTimeItem != null) {
                this.fOnTimePanel.loadFieldContents();
            }
            if (this.fOffTimeItem != null) {
                this.fOffTimePanel.loadFieldContents();
            }
        }

        public void storeFieldContents() {
            if (this.fWeekdayItem != null) {
                this.fWeekDaysPanel.storeFieldContents();
            }
            if (this.fOnTimeItem != null) {
                this.fOnTimePanel.storeFieldContents();
            }
            if (this.fOffTimeItem != null) {
                this.fOffTimePanel.storeFieldContents();
            }
        }

        public boolean checkChanged() {
            return this.fWeekdayItem != null && this.fWeekDaysPanel.checkChanged() || this.fOnTimeItem != null && this.fOnTimePanel.checkChanged() || this.fOffTimeItem != null && this.fOffTimePanel.checkChanged();
        }
    }

    public static class CamTimePanel
    extends BorderJPanel {
        private static final long serialVersionUID = 410425841303511174L;
        private transient TimeInputPanel fTimeInputPanel = null;
        private ClockHours fClockHours = null;
        ParameterItem fParameterItem = null;
        private JCheckBox cbTimeInactive;
        private Integer fLogoMode = 0;
        private CamParameter fCamParameter = null;

        public CamTimePanel(ParameterItem parameterItem, ClockHours clockHours, Integer logoMode) {
            this.fClockHours = clockHours;
            this.fTimeInputPanel = new TimeInputPanel();
            this.fParameterItem = parameterItem;
            this.fCamParameter = UDFBlockPanel.getCamParameter(this.fParameterItem);
            this.fLogoMode = logoMode;
            this.add(this.fTimeInputPanel);
            if (parameterItem.getParameter() instanceof ClockParameter) {
                SymItem lSymItem = new SymItem();
                this.cbTimeInactive = new JCheckBox();
                this.cbTimeInactive.setText(Language.getString("dialog.parameter.cam.inactive", "Inaktiv"));
                this.cbTimeInactive.setActionCommand("Inaktiv");
                this.cbTimeInactive.setBounds(12, 54, 120, 24);
                this.cbTimeInactive.addItemListener(lSymItem);
                this.add(this.cbTimeInactive);
            }
        }

        public void loadFieldContents() {
            this.fTimeInputPanel.loadFieldContents(this.fClockHours);
            if (this.fParameterItem.getParameter() instanceof ClockParameter) {
                String identifier = this.fParameterItem.getIdentifier();
                if ("On0".equals(identifier) || "On1".equals(identifier) || "On2".equals(identifier)) {
                    this.cbTimeInactive.setSelected(this.fCamParameter.getOnTime().isInactive());
                } else if ("Off0".equals(identifier) || "Off1".equals(identifier) || "Off2".equals(identifier)) {
                    this.cbTimeInactive.setSelected(this.fCamParameter.getOffTime().isInactive());
                }
            }
        }

        public void storeFieldContents() {
            this.fTimeInputPanel.storeFieldContents(this.fClockHours);
            if (this.fParameterItem.getParameter() instanceof ClockParameter) {
                String identifier = this.fParameterItem.getIdentifier();
                if ("On0".equals(identifier) || "On1".equals(identifier) || "On2".equals(identifier)) {
                    this.fCamParameter.getOnTime().setInactive(this.cbTimeInactive.isSelected() || this.fLogoMode == 0);
                } else if ("Off0".equals(identifier) || "Off1".equals(identifier) || "Off2".equals(identifier)) {
                    this.fCamParameter.getOffTime().setInactive(this.cbTimeInactive.isSelected() || this.fLogoMode == 0);
                }
            }
        }

        public boolean checkChanged() {
            if (this.fParameterItem.getParameter() instanceof ClockParameter) {
                String identifier = this.fParameterItem.getIdentifier();
                if ("On0".equals(identifier) || "On1".equals(identifier) || "On2".equals(identifier)) {
                    boolean onTimeInactive;
                    boolean bl = onTimeInactive = this.cbTimeInactive.isSelected() || this.fLogoMode == 0;
                    if (this.fCamParameter.getOnTime().isInactive() != onTimeInactive) {
                        return true;
                    }
                } else if ("Off0".equals(identifier) || "Off1".equals(identifier) || "Off2".equals(identifier)) {
                    boolean offTimeInactive;
                    boolean bl = offTimeInactive = this.cbTimeInactive.isSelected() || this.fLogoMode == 0;
                    if (this.fCamParameter.getOffTime().isInactive() != offTimeInactive) {
                        return true;
                    }
                }
            }
            return this.fTimeInputPanel.checkChanged(this.fClockHours);
        }

        public void setPulseMode(boolean pulseMode) {
            this.cbTimeInactive.setEnabled(!pulseMode);
            this.fTimeInputPanel.setEnabled(!pulseMode);
            this.setEnabled(!pulseMode);
        }

        void cbOffTimeInactive_itemStateChanged() {
            this.fTimeInputPanel.setEnabled(!this.cbTimeInactive.isSelected());
        }

        void cbOnTimeInactive_itemStateChanged() {
            this.fTimeInputPanel.setEnabled(!this.cbTimeInactive.isSelected());
        }

        class SymItem
        implements ItemListener {
            SymItem() {
            }

            public void itemStateChanged(ItemEvent event) {
                Object object = event.getSource();
                if (object == CamTimePanel.this.cbTimeInactive) {
                    CamTimePanel.this.cbOnTimeInactive_itemStateChanged();
                } else if (object == CamTimePanel.this.cbTimeInactive) {
                    CamTimePanel.this.cbOffTimeInactive_itemStateChanged();
                }
            }
        }
    }

    public static class ClockHoursPanel
    extends BorderJPanel {
        private static final long serialVersionUID = -9147186402076703354L;
        private transient TimeInputPanel fTimeInputPanel = null;
        private ClockHours fClockHours = null;

        public ClockHoursPanel(ClockHours clockHours) {
            this.fClockHours = clockHours;
            this.fTimeInputPanel = new TimeInputPanel();
            this.add(this.fTimeInputPanel);
        }

        public void loadFieldContents() {
            this.fTimeInputPanel.loadFieldContents(this.fClockHours);
        }

        public void storeFieldContents() {
            this.fTimeInputPanel.storeFieldContents(this.fClockHours);
        }

        public boolean checkChanged() {
            return this.fTimeInputPanel.checkChanged(this.fClockHours);
        }
    }
}

